package data.scripts.hullmods;

import com.fs.starfarer.api.combat.BaseHullMod;
import com.fs.starfarer.api.combat.MutableShipStatsAPI;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.ShipAPI.HullSize;

public class SWP_FuelExpansion extends BaseHullMod {

    public static final float FUEL_BONUS0 = 20f;
    public static final float FUEL_BONUS1 = 40f;
    public static final float FUEL_BONUS2 = 60f;
    public static final float FUEL_BONUS3 = 100f;

    @Override
    public void applyEffectsBeforeShipCreation(HullSize hullSize, MutableShipStatsAPI stats, String id) {
        if (hullSize == HullSize.FRIGATE) {
            stats.getFuelMod().modifyFlat(id, FUEL_BONUS0);
        }
        if (hullSize == HullSize.DESTROYER) {
            stats.getFuelMod().modifyFlat(id, FUEL_BONUS1);
        }
        if (hullSize == HullSize.CRUISER) {
            stats.getFuelMod().modifyFlat(id, FUEL_BONUS2);
        }
        if (hullSize == HullSize.CAPITAL_SHIP) {
            stats.getFuelMod().modifyFlat(id, FUEL_BONUS3);
        }
    }

    @Override
    public String getDescriptionParam(int index, HullSize hullSize) {
        if (index == 0) {
            return "" + (int) FUEL_BONUS0;
        }
        if (index == 1) {
            return "" + (int) FUEL_BONUS1;
        }
        if (index == 2) {
            return "" + (int) FUEL_BONUS2;
        }
        if (index == 3) {
            return "" + (int) FUEL_BONUS3;
        }
        return null;
    }

    @Override
    public String getUnapplicableReason(ShipAPI ship) {
        if (ship.getVariant().hasHullMod("diableavionics_cramped")) {
            return "Cannot be installed on a cramped hull";
        }
        if (ship.getVariant().hasHullMod("cargo_expansion")) {
            return "Incompatible with Expanded Cargo";
        }
        if (ship.getVariant().hasHullMod("additional_crew_quarters")) {
            return "Incompatible with Expanded Crew Quarters";
        }

        return null;
    }

    @Override
    public boolean isApplicableToShip(ShipAPI ship) {
        return ship != null && !ship.getVariant().getHullMods().contains("cargo_expansion")
                && !ship.getVariant().getHullMods().contains("additional_crew_quarters")
                && !ship.getVariant().getHullMods().contains("diableavionics_cramped");
    }
}
